import { NumericPoint } from '/sd:numeric-point.js'; 
import { DialogWindow } from '/sd:dialog-window.js'; 
/**
 * class to create instance of extended NumericPoint about additional invoking DialogWindow to set new value in modbus register 
 */
export class NumericSetPoint extends NumericPoint {	
	/**
	 * Constructor
	 * @param {jQuery} xmlObject    		Data loaded from XML - accept numeric set points part only
	 * @param {String} parentId				HTML ID of the object, which has to be a parent of constructing numeric set point
	 * @param {Integer} itemNumber			Number of object constructing numeric point
	 * @param {jQuery} enumsDefXmlObject    Data loaded from XML - accept enums definition part only
	 * @param {String} floatSeparator		Name of chosen float separator
	 * @param {String} pointMainClass		Name of the CSS style's class of numeric set point
	 * @param {Integer} holdingRegister		Holding register address in decimal
	 * @param {Float} scale					Scale for read from Modbus value
	 * @param {String} unit					Unit added after value
	 * @param {String} enumName				Enum name if value isn't numeric type
	 */
	constructor(xmlObject, parentId, itemNumber = 0, enumsDefXmlObject, floatSeparator, pointMainClass = "NumericSetPoint", holdingRegister=null, scale=null, unit=null, enumName=null, pointRefreshFrequency=null) {
		super(xmlObject, parentId, itemNumber, enumsDefXmlObject, floatSeparator, pointMainClass, holdingRegister, scale, unit, enumName, pointRefreshFrequency);
		this.childValue.mainObj.setAttribute("onclick", "NumericSetPoint.ShowNumericDialogWindow(this.id, window.dialogWindow, numericSetPoints)");
	}
	
	/**
	 * Opens popup window (DialogWindow) for editing Numeric SetPoint
	 * @param {String} id 									ID of the numeric set point
	 * @param {DialogWindow} dialogWindow 					DialogWindow instance
	 * @param {Array(NumericSetPoint)} numericSetPoints 	Array of all declared NumericSetPoints
	 */
	static ShowNumericDialogWindow(id, dialogWindow, numericSetPoints) {
		var identifier = id.slice(0, id.length - 5);
		var i;
		for(i=0; i < numericSetPoints.length; i++) {
			if(numericSetPoints[i].getId() == identifier) {
				break;
			}
		}
		if(i != numericSetPoints.length)
			dialogWindow.show(numericSetPoints[i]);
		else
			console.log("NumericSetPoint " + identifier + " was no found!");
	}
}
window.NumericSetPoint = NumericSetPoint;